package com.hxstrive.demo_springcloud_openfeign.controller;

import com.hxstrive.demo_springcloud_openfeign.entity.SpringQueryMapObj;
import com.hxstrive.demo_springcloud_openfeign.feign.AdvancedFeign;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * 高级用法控制器
 * @author hxstrive.com
 * @since 1.0.0  2024/11/11 10:44
 */
@RestController
public class AdvancedController {

    @Autowired
    private AdvancedFeign advancedFeign;


    @GetMapping("/advanced/demo1")
    public String demo1() {
        return advancedFeign.demo1(Arrays.asList("one", "two", "three"));
    }

    @GetMapping("/advanced/demo2")
    public String demo2() {
        return advancedFeign.demo2(SpringQueryMapObj.builder().name("Bill").age(40).build());
    }

    @GetMapping("/advanced/demo3")
    public String demo3() {
        Map<String,String> map = new HashMap<>();
        map.put("name", "Bill");
        map.put("age", "40");
        return advancedFeign.demo3(map);
    }


    @GetMapping(path = "/advanced/demo4")
    public String demo4() {
        return advancedFeign.demo4();
    }




}
