package com.hxstrive.demo_springcloud_openfeign.controller;

import com.hxstrive.demo_springcloud_openfeign.dto.CommonReturn;
import com.hxstrive.demo_springcloud_openfeign.entity.User;
import com.hxstrive.demo_springcloud_openfeign.feign.SimpleFeign;
import com.hxstrive.demo_springcloud_openfeign.feign.UserFeign;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

/**
 * 控制器
 * @author hxstrive.com
 */
@RestController
public class FeignController {

    @Autowired
    private SimpleFeign simpleFeign;


    @GetMapping("/hello")
    public Object hello() {
        return simpleFeign.hello();
    }

    @GetMapping("/get1")
    public String get1() {
        return simpleFeign.get();
    }

    @GetMapping("/get2")
    public String get2(@RequestParam("id") Long id) {
        return simpleFeign.get(id);
    }

    @GetMapping("/demo1")
    public String demo1() {
        return simpleFeign.demo1();
    }


    @GetMapping("/demo2")
    public CommonReturn<User> demo2(@RequestParam("id") Long id) {
        return simpleFeign.demo2(id);
    }

    @GetMapping("/demo3")
    public CommonReturn<User> demo3(@RequestParam("id") Long id, @RequestParam("name") String name,
                                         @RequestParam("age") Integer age) {
        User user = User.builder().id(id).name(name).age(age).build();
        return simpleFeign.demo3(user);
    }


    @GetMapping("/demo4")
    public String demo4(@RequestParam("id") Long id) {
        return simpleFeign.post1(id);
    }

    @GetMapping("/demo5")
    public CommonReturn<User> demo5(@RequestParam("id") Long id, @RequestParam("name") String name,
                                    @RequestParam("age") Integer age) {
        User user = User.builder().id(id).name(name).age(age).build();
        return simpleFeign.post2(user);
    }

    // 上传文件
    @PostMapping(value = "/upload", consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    public ResponseEntity<String> uploadFile(@RequestPart("file") MultipartFile file) {
        return simpleFeign.uploadFile(file);
    }

    // 下载文件
    @GetMapping("/download/{filename}")
    public ResponseEntity<byte[]> downloadFile(@PathVariable("filename") String filename) {
        return simpleFeign.downloadFile(filename);
    }

    // 负载均衡
    @GetMapping("/info")
    public String info() {
        return simpleFeign.info();
    }

}
