package com.hxstrive.demo_springcloud_openfeign.controller;

import com.hxstrive.demo_springcloud_openfeign.dto.CommonReturn;
import com.hxstrive.demo_springcloud_openfeign.entity.User;
import com.hxstrive.demo_springcloud_openfeign.feign.UserFeign;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author HuangXin
 * @since 1.0.0  2024/11/8 14:09
 */
@RestController
@RequestMapping("/user")
public class UserFeignController {

    @Autowired
    private UserFeign userFeign;


    @GetMapping("/getAllUsers")
    public CommonReturn<List<User>> getAllUsers() {
        return userFeign.getAllUsers();
    }

    @GetMapping("/getUserById")
    public CommonReturn<User> getUserById(@RequestParam("id") Long id) {
        return userFeign.getUserById(id);
    }

    @GetMapping("/createUser")
    public CommonReturn<User> createUser(@RequestParam("id") Long id, @RequestParam("name") String name,
                                         @RequestParam("age") Integer age) {
        User user = User.builder().id(id).name(name).age(age).build();
        return userFeign.createUser(user);
    }

    @GetMapping("/updateUser")
    public CommonReturn<User> updateUser(@RequestParam("id") Long id, @RequestParam("name") String name,
                                         @RequestParam("age") Integer age) {
        User user = User.builder().id(id).name(name).age(age).build();
        return userFeign.updateUser(id, user);
    }

    @GetMapping("/deleteUser")
    public CommonReturn<String> deleteUser(@RequestParam("id") Long id) {
        return userFeign.deleteUser(id);
    }

}
