package com.hxstrive.demo_springcloud_openfeign.controller;

import com.hxstrive.demo_springcloud_openfeign.dto.CommonReturn;
import com.hxstrive.demo_springcloud_openfeign.entity.User;
import com.hxstrive.demo_springcloud_openfeign.feign.UserRestfulFeign;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author HuangXin
 * @since 1.0.0  2024/11/8 14:38
 */
@RestController
@RequestMapping("/user/restful")
public class UserRestfulFeignController {

    @Autowired
    private UserRestfulFeign userRestfulFeign;


    // GET 请求，获取所有用户信息
    @GetMapping("/getAllUsers")
    public CommonReturn<List<User>> getAllUsers() {
        return userRestfulFeign.getAllUsers();
    }

    // GET 请求，根据用户 ID 获取用户信息
    @GetMapping("/getUserById")
    public CommonReturn<User> getUserById(@RequestParam("id") Long id) {
        return userRestfulFeign.getUserById(id);
    }

    // POST 请求，创建新用户
    @GetMapping("/createUser")
    public CommonReturn<User> createUser(@RequestParam("id") Long id, @RequestParam("name") String name,
                                         @RequestParam("age") Integer age) {
        User user = User.builder().id(id).name(name).age(age).build();
        return userRestfulFeign.createUser(user);
    }

    // PUT 请求，更新用户信息
    @GetMapping("/updateUser")
    public CommonReturn<User> updateUser(@RequestParam("id") Long id, @RequestParam("name") String name,
                                         @RequestParam("age") Integer age) {
        User user = User.builder().id(id).name(name).age(age).build();
        return userRestfulFeign.updateUser(id, user);
    }

    // DELETE 请求，删除用户
    @GetMapping("/deleteUser")
    public CommonReturn<String> deleteUser(@RequestParam("id") Long id) {
        return userRestfulFeign.deleteUser(id);
    }

}
