package com.hxstrive.demo_springcloud_openfeign.feign;

import com.hxstrive.demo_springcloud_openfeign.config.FeignConfig;
import com.hxstrive.demo_springcloud_openfeign.entity.SpringQueryMapObj;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cloud.openfeign.CollectionFormat;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * OpenFeign 高级用法
 * @author hxstrive.com
 * @since 1.0.0  2024/11/11 10:43
 */
@FeignClient(value = "SERVICE-DEMO", contextId = "advancedFeign", path = "/simple",
        configuration = FeignConfig.class)
public interface AdvancedFeign {

    // @CollectionFormat 注解可以指定参数的集合格式
    //@CollectionFormat(feign.CollectionFormat.CSV)
    @CollectionFormat(feign.CollectionFormat.EXPLODED)
    @GetMapping(path = "/hello")
    String demo1(@RequestParam("list") List<String> list);

    // @SpringQueryMap 注解可以自动将 Map 参数转换为 URL 参数
    @GetMapping(path = "/hello")
    String demo2(@SpringQueryMap SpringQueryMapObj map);

    @GetMapping(path = "/hello")
    String demo3(@SpringQueryMap Map<String,String> map);

    // @Cacheable 注解可以开启缓存
    @Cacheable("info")
    @GetMapping(path = "/info")
    String demo4();

}
