package com.hxstrive.demo_springcloud_openfeign.feign;

import com.hxstrive.demo_springcloud_openfeign.config.FeignConfig;
import com.hxstrive.demo_springcloud_openfeign.dto.CommonReturn;
import com.hxstrive.demo_springcloud_openfeign.entity.User;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

/**
 * 用户 Feign
 * @author hxstrive.com
 */
@FeignClient(value = "SERVICE-DEMO", configuration = FeignConfig.class)
public interface SimpleFeign {

    @GetMapping("/simple/hello")
    String hello();

    @GetMapping("/simple/hello")
    String get();

    @GetMapping("/simple/get")
    String get(@RequestParam("id") Long id);

    @RequestMapping(value = "/simple/hello", method = RequestMethod.GET)
    String demo1();

    // get请求
    @RequestMapping("/user/getUserById")
    CommonReturn<User> demo2(Long id);

    @RequestMapping("/user/createUser")
    CommonReturn<User> demo3(User user);

    // post请求
    @PostMapping("/simple/post")
    String post1(@RequestParam("id") Long id);

    @PostMapping("/user/createUser")
    CommonReturn<User> post2(@RequestBody User user);

    // 上传文件
    @PostMapping(value = "/simple/upload", consumes=MediaType.MULTIPART_FORM_DATA_VALUE)
    ResponseEntity<String> uploadFile(@RequestPart("file") MultipartFile file);

    // 下载文件
    @GetMapping("/simple/download/{filename}")
    ResponseEntity<byte[]> downloadFile(@PathVariable("filename") String filename);

    // 负载均衡
    @GetMapping("/simple/info")
    String info();
}
