package com.hxstrive.demo_springcloud_openfeign.feign;

import com.hxstrive.demo_springcloud_openfeign.dto.CommonReturn;
import com.hxstrive.demo_springcloud_openfeign.entity.User;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * USER Feign 接口
 * @author HuangXin
 * @since 1.0.0  2024/11/8 14:01
 */
@FeignClient(value = "SERVICE-DEMO", contextId = "userFeignClient")
public interface UserFeign {

    @GetMapping("/user/getAllUsers")
    CommonReturn<List<User>> getAllUsers();

    @GetMapping("/user/getUserById")
    CommonReturn<User> getUserById(@RequestParam("id") Long id);

    @PostMapping("/user/createUser")
    CommonReturn<User> createUser(@RequestBody User user);

    @PutMapping("/user/updateUser")
    CommonReturn<User> updateUser(@RequestParam("id") Long id, @RequestBody User updatedUser);

    @DeleteMapping("/user/deleteUser")
    CommonReturn<String> deleteUser(@RequestParam("id") Long id);

}
