package com.hxstrive.demo_springcloud_openfeign.feign;

import com.hxstrive.demo_springcloud_openfeign.dto.CommonReturn;
import com.hxstrive.demo_springcloud_openfeign.entity.User;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * USER Restful Feign 客户端
 * @author HuangXin
 * @since 1.0.0  2024/11/8 14:01
 */
@FeignClient(value = "SERVICE-DEMO", contextId = "userRestfulFeign")
public interface UserRestfulFeign {

    // GET 请求，获取所有用户信息
    @GetMapping("/user/restful/getAllUsers")
    CommonReturn<List<User>> getAllUsers();

    // GET 请求，根据用户 ID 获取用户信息
    @GetMapping("/user/restful/{id}")
    CommonReturn<User> getUserById(@PathVariable Long id);

    // POST 请求，创建新用户
    @PostMapping("/user/restful/createUser")
    CommonReturn<User> createUser(@RequestBody User user);

    // PUT 请求，更新用户信息
    @PutMapping("/user/restful/{id}")
    CommonReturn<User> updateUser(@PathVariable Long id, @RequestBody User updatedUser);

    // DELETE 请求，删除用户
    @DeleteMapping("/user/restful/{id}")
    CommonReturn<String> deleteUser(@PathVariable Long id);

}
