package com.hxstrive.demo_springcloud_openfeign.feign.fallback;

import org.springframework.cloud.openfeign.FallbackFactory;

/**
 * @author HuangXin
 * @since 1.0.0  2024/11/12 16:10
 */
public class DemoFallbackFactory implements FallbackFactory<DemoFeign> {

    @Override
    public DemoFeign create(Throwable cause) {
        System.out.println("create() cause: " + cause.getMessage() + ", cause class: " + cause.getClass().getName());
        return new DemoFeign() {
            @Override
            public String info() {
                return cause.getMessage();
            }
        };
    }

}
