package com.hxstrive.service_demo.controller;

import com.hxstrive.service_demo.entity.User;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.util.Map;
import java.util.UUID;

/**
 * 简单控制器
 * @author hxstrive.com
 */
@RestController
@RequestMapping("/simple")
public class SimpleController {

    @Value("${spring.application.name}")
    private String appName;

    @Value("${server.port}")
    private String appPort;

    @GetMapping("/hello")
    public String hello(HttpServletRequest request) {
        return "Hello World";
    }

    @GetMapping("/hello2")
    public String hello2(@RequestParam("args") String[] args) {
        return "Hello World, args=" + String.join("、", args);
    }

    @GetMapping("/info")
    public String info() {
        return "appName=" + appName + " appPort=" + appPort + " uuid=" + UUID.randomUUID().toString();
    }

    @GetMapping("/get")
    public String get(@RequestParam("id") Long id) {
        return "appName=" + appName + " appPort=" + appPort + " id=" + id;
    }

    @GetMapping("/param1")
    public String param1(@RequestParam("token") String token) {
        return "token=" + token;
    }

    @GetMapping("/param2")
    public String param2(@RequestHeader("Authorization") String token) {
        return "Authorization=" + token;
    }

    @PostMapping("/param3")
    public String param3(@RequestBody String body) {
        return "body=" + body;
    }

    @GetMapping("/header1")
    public String header1(@RequestHeader("Custom-Header") String customHeader,
                          @RequestHeader("Authorization") String token,
                          @RequestHeader("Content-Type") String contentType) {
        return "Custom-Header=" + customHeader +
                "<br/>Authorization=" + token +
                "<br/>Content-Type=" + contentType;
    }

    @PostMapping("/body1")
    public Map<String,String> body1(@RequestBody Map<String,String> body) {
        body.put("service_name", "ServiceDemo");
        return body;
    }

    @PostMapping("/body2")
    public User body2(@RequestBody User user) {
        return user;
    }

    @GetMapping("/query")
    public User query(@RequestParam("id") Long id, @RequestParam("name") String name, @RequestParam("age") Integer age) {
        return User.builder().id(id).name(name).age(age).build();
    }

    @GetMapping("/interceptor")
    public String interceptor(@RequestHeader("X-Forwarded-For") String xForwardedFor, @RequestParam("msg") String msg) {
        return "xForwardedFor=" + xForwardedFor + "<br/>msg=" + msg;
    }

    @PostMapping("/encode")
    public User encode(@RequestBody User user) {
        System.out.println(user);
        return user;
    }

    @PostMapping("/post")
    public String post(@RequestParam("id") Long id) {
        return "appName=" + appName + " appPort=" + appPort + " id=" + id;
    }

    @PostMapping("/upload")
    public ResponseEntity<String> uploadFile(@RequestParam("file") MultipartFile file) {
        if (file.isEmpty()) {
            return new ResponseEntity<>("请选择要上传的文件", HttpStatus.BAD_REQUEST);
        }

        try {
            // 将文件保存到指定目录，这里假设保存到项目根目录下的 uploads 文件夹
            File destination = new File("D:\\tmp\\uploads\\" + file.getOriginalFilename());
            file.transferTo(destination);
            return new ResponseEntity<>("文件上传成功", HttpStatus.OK);
        } catch (Exception e) {
            return new ResponseEntity<>("文件上传失败：" + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping("/download/{filename}")
    public ResponseEntity<byte[]> downloadFile(@PathVariable("filename") String filename) {
        try {
            java.io.File file = new java.io.File("D:\\tmp\\uploads\\" + filename);
            byte[] fileContent = java.nio.file.Files.readAllBytes(file.toPath());

            // 设置响应头，告诉浏览器这是一个文件下载，并且指定文件名
            org.springframework.http.HttpHeaders headers = new org.springframework.http.HttpHeaders();
            headers.add("Content-Disposition", "attachment; filename=" + filename);

            // 返回文件内容、响应头和状态码200（表示成功）
            return new ResponseEntity<>(fileContent, headers, org.springframework.http.HttpStatus.OK);
        } catch (Exception e) {
            // 如果出现异常，返回状态码500（表示服务器内部错误）
            return new ResponseEntity<>(null, null,
                    org.springframework.http.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

}
