package com.hxstrive.service_demo.handler;

import com.hxstrive.service_demo.dto.CommonReturn;
import com.hxstrive.service_demo.exception.BusinessException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * 全局异常处理
 * @author hxstrive.com
 * @since 1.0.0  2024/10/23 9:28
 */
@ControllerAdvice
public class GlobalExceptionHandler {

    @ExceptionHandler(BusinessException.class)
    @ResponseBody
    public CommonReturn<?> handleBusinessException(BusinessException e) {
        return CommonReturn.fail(e.getMessage());
    }

    @ExceptionHandler(Exception.class)
    @ResponseBody
    public CommonReturn<?> handleException(Exception e) {
        return CommonReturn.fail("服务异常，稍后再试");
    }

}
