package com.hxstrive.hystrix_demo;

import com.netflix.hystrix.contrib.javanica.annotation.DefaultProperties;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.circuitbreaker.EnableCircuitBreaker;
import org.springframework.cloud.netflix.hystrix.EnableHystrix;
import org.springframework.cloud.netflix.hystrix.dashboard.EnableHystrixDashboard;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 入库类
 * @author hxstrive.com
 */
@RestController
@SpringBootApplication
// 启用断路器
@EnableCircuitBreaker
@EnableHystrix
// 开启 Hystrix Dashboard 的功能
@EnableHystrixDashboard
// 开启 Feign
@EnableFeignClients
public class HystrixDemoApplication {

    @Value("${spring.application.name}")
    private String appName;

    @Value("${server.port}")
    private String appPort;

    public static void main(String[] args) {
        SpringApplication.run(HystrixDemoApplication.class, args);
    }

    @GetMapping("/")
    public String index() {
        return "appName=" + appName + ", appPort=" + appPort;
    }

}
