package com.hxstrive.hystrix_demo.config;

import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

/**
 * RestTemplate 配置类
 * @author hxstrive.com
 */
@Configuration
public class RestTemplateConfig {

    // 配置一个 RestTemplate
    @Bean
    // 添加该注解后，可以使得 RestTemplate 拥有负载均衡能力
    @LoadBalanced
    public RestTemplate restTemplate() {
        return new RestTemplate();
    }

}
