package com.hxstrive.hystrix_demo.controller;

import com.hxstrive.hystrix_demo.dto.CommonReturn;
import com.hxstrive.hystrix_demo.entity.User;
import com.hxstrive.hystrix_demo.service.UserService;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author hxstrive.com
 */
@RestController
@RequestMapping("/demo1")
public class Demo1Controller {

    @Autowired
    private UserService userService;

    @GetMapping("/getAllUsers")
    @HystrixCommand(fallbackMethod = "fallback")
    public CommonReturn<List<User>> getAllUsers() {
        return userService.getAllUsers();
    }

    /**
     * 当服务调用失败时，调用此方法
     */
    private CommonReturn<List<User>> fallback() {
        return CommonReturn.fail("网络出现问题，调用 fallback 方法");
    }

}
