package com.hxstrive.hystrix_demo.controller;

import com.hxstrive.hystrix_demo.dto.CommonReturn;
import com.hxstrive.hystrix_demo.entity.User;
import com.hxstrive.hystrix_demo.service.UserService;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * Hystrix 降级
 * @author hxstrive.com
 */
@RestController
@RequestMapping("/demo2")
public class Demo2Controller {

    @Autowired
    private UserService userService;

    @GetMapping("/getUserById")
    @HystrixCommand(fallbackMethod = "fallback")
    public CommonReturn<User> getUserById(@RequestParam Long id) {
        return userService.getUserById(id);
    }

    /**
     * 当服务调用失败时，调用此方法
     */
    private CommonReturn<User> fallback(Long id) {
        return CommonReturn.fail("网络出现问题，调用 fallback 方法，id=" + id);
    }

}
