package com.hxstrive.hystrix_demo.controller;

import com.hxstrive.hystrix_demo.dto.CommonReturn;
import com.hxstrive.hystrix_demo.entity.User;
import com.hxstrive.hystrix_demo.service.UserService;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixProperty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * Hystrix 线程池隔离
 * @author hxstrive.com
 */
@RestController
@RequestMapping("/demo4")
public class Demo4Controller {

    @Autowired
    private UserService userService;

    @GetMapping("/getUserById")
    @HystrixCommand(groupKey = "gk_user", commandKey = "ck_getUserById", threadPoolKey = "tpk_user",
        threadPoolProperties = {
                // 设置线程池核心线程数为4，最大队列长度为128，空闲线程存活2分钟，当队列长度为 120 时开始拒绝请求
                // 设置线程池的核心线程数量
                @HystrixProperty(name = "coreSize", value = "4"),
                // 设置线程池的最大队列长度
                @HystrixProperty(name = "maxQueueSize", value = "128"),
                // 设置线程池中空闲线程的存活时间，单位：分钟
                @HystrixProperty(name = "keepAliveTimeMinutes", value = "2"),
                // 设置队列拒绝请求的阈值，该值通常小于 maxQueueSize
                @HystrixProperty(name = "queueSizeRejectionThreshold", value = "120")
        })
    public CommonReturn<User> getUserById(@RequestParam Long id) {
        System.out.println("Thread Name :: " + Thread.currentThread().getName());
        return userService.getUserById(id);
    }

}
