package com.hxstrive.hystrix_demo.controller;

import com.hxstrive.hystrix_demo.dto.CommonReturn;
import com.hxstrive.hystrix_demo.entity.User;
import com.hxstrive.hystrix_demo.semaphore_demo.RemoteService;
import com.hxstrive.hystrix_demo.semaphore_demo.RemoteServiceCommand;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * Hystrix 信号量隔离
 * @author hxstrive.com
 */
@RestController
@RequestMapping("/demo5")
public class Demo5Controller {

    @Autowired
    private RemoteService remoteService;

    @GetMapping("/getAllUsers")
    public CommonReturn<List<User>> getAllUsers() {
        RemoteServiceCommand remoteServiceCommand = new RemoteServiceCommand(remoteService);
        CommonReturn<List<User>> commonReturn = remoteServiceCommand.execute();
        if(commonReturn.getCode() != 1) {
            throw new RuntimeException("获取用户列表失败，原因：" + commonReturn.getMessage());
        }
        return commonReturn;
    }

}
