package com.hxstrive.hystrix_demo.controller;

import com.hxstrive.hystrix_demo.dto.CommonReturn;
import com.hxstrive.hystrix_demo.entity.User;
import com.hxstrive.hystrix_demo.feign.UserServiceFeign;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * Hystrix Feign 降级
 * @author hxstrive.com
 */
@RestController
@RequestMapping("/demo7")
public class Demo7Controller {

    @Autowired
    private UserServiceFeign userServiceFeign;

    @GetMapping("/getUserById")
    public CommonReturn<User> getUserById(@RequestParam Long id) {
        return userServiceFeign.getUserById(id);
    }

}
