package com.hxstrive.hystrix_demo.controller;

import com.hxstrive.hystrix_demo.entity.User;
import com.hxstrive.hystrix_demo.quest_collapser.QuestCollapserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import java.util.concurrent.Future;

/**
 * Hystrix 请求合并
 * @author hxstrive.com
 */
@RestController
@RequestMapping("/demo9")
public class Demo9Controller {

    @Autowired
    private QuestCollapserService questCollapserService;

    /**
     * 在控制器中调用请求合并方法，根据用户ID获取用户信息
     */
    @GetMapping("/getUserById")
    public String getUserById() throws Exception {
        System.out.println("getUserById() 方法执行了..." + questCollapserService);
        Future<User> future1 = questCollapserService.collapserGetUserById(1L);
        Future<User> future2 = questCollapserService.collapserGetUserById(2L);
        Future<User> future3 = questCollapserService.collapserGetUserById(3L);

        System.out.println("future1: " + future1.get());
        System.out.println("future2: " + future2.get());
        System.out.println("future3: " + future3.get());

        return "success";
    }


}
