package com.hxstrive.hystrix_demo.feign;

import com.hxstrive.hystrix_demo.dto.CommonReturn;
import com.hxstrive.hystrix_demo.entity.User;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * @author hxstrive.com
 * @since 1.0.0  2024/11/19 14:25
 */
@Component
public class UserServiceFallback implements UserServiceFeign {

    @Override
    public CommonReturn<User> getUserById(Long id) {
        return CommonReturn.fail("调用失败，触发 fallback");
    }

    @Override
    public List<User> batchGetUserById(List<Long> ids) {
        List<User> retList = new ArrayList<>();
        for(Long id : ids) {
            retList.add(null);
        }
        return retList;
    }

}
