package com.hxstrive.hystrix_demo.feign;

import com.hxstrive.hystrix_demo.dto.CommonReturn;
import com.hxstrive.hystrix_demo.entity.User;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author hxstrive.com
 * @since 1.0.0  2024/11/19 14:24
 */
@Component
@FeignClient(name = "SERVICE-DEMO", fallback = UserServiceFallback.class)
public interface UserServiceFeign {

    @GetMapping("/user/getUserById")
    CommonReturn<User> getUserById(@RequestParam("id") Long id);

    @PostMapping(value = "/user/batchGetUserById", consumes = MediaType.APPLICATION_JSON_VALUE)
    List<User> batchGetUserById(@RequestBody List<Long> ids);

}
