package com.hxstrive.hystrix_demo.quest_collapser;

import com.hxstrive.hystrix_demo.entity.User;
import com.hxstrive.hystrix_demo.feign.UserServiceFeign;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixCollapser;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixProperty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Future;

/**
 * @author hxstrive.com
 */
@Service
public class QuestCollapserService {

    @Autowired
    private UserServiceFeign userServiceFeign;

    /**
     * 定义请求合并，设置合并时间窗口等属性
     */
    @HystrixCollapser(batchMethod = "batchMethod", scope = com.netflix.hystrix.HystrixCollapser.Scope.GLOBAL,
            collapserProperties = {
                // 进行一次请求合并的窗口时间为 100 毫秒
                @HystrixProperty(name = "timerDelayInMilliseconds", value = "100"),
                // 一次最大合并 20 个请求
                @HystrixProperty(name = "maxRequestsInBatch", value = "20")
    })
    public Future<User> collapserGetUserById(Long id) {
        // 你会发现根本不会进入这个方法体
        System.out.println("collapserGetUserById() 方法执行了..." + id);
        return null;
    }

    /**
     * 批量获取用户信息的方法，对应上面 @HystrixCollapser 注解中指定的batchMethod
     * @param ids 用户ID列表
     * @return 用户信息列表
     */
    @HystrixCommand
    public List<User> batchMethod(List<Long> ids) {
        System.out.println("batchMethod() 方法执行了..." + Arrays.toString(ids.toArray()));
        return userServiceFeign.batchGetUserById(ids);
    }

}
