package com.hxstrive.hystrix_demo.semaphore_demo;

import com.hxstrive.hystrix_demo.dto.CommonReturn;
import com.hxstrive.hystrix_demo.entity.User;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author hxstrive.com
 * @since 1.0.0  2024/11/19 9:33
 */
public class RemoteServiceCommand extends HystrixCommand<CommonReturn<List<User>>> {

    private final RemoteService remoteService;

    public RemoteServiceCommand(RemoteService remoteService) {
        super(Setter.withGroupKey(HystrixCommandGroupKey.Factory.asKey("RemoteServiceGroup"))
                .andCommandPropertiesDefaults(HystrixCommandProperties.Setter()
                        .withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE)
                        .withExecutionIsolationSemaphoreMaxConcurrentRequests(5)));
        this.remoteService = remoteService;
    }

    @Override
    protected CommonReturn<List<User>> run() throws Exception {
        return remoteService.getAllUsers();
    }

    @Override
    protected CommonReturn<List<User>> getFallback() {
        return CommonReturn.fail("Call fallback");
    }

}
