package com.hxstrive.hystrix_demo.semaphore_demo;

import com.hxstrive.hystrix_demo.dto.CommonReturn;
import com.hxstrive.hystrix_demo.entity.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.List;

/**
 * @author hxstrive.com
 * @since 1.0.0  2024/11/19 9:32
 */
@Service
public class RemoteServiceImpl implements RemoteService {

    @Autowired
    private RestTemplate restTemplate;

    // 调用根据用户ID获取用户信息的接口
    @Override
    public CommonReturn<List<User>> getAllUsers() {
        try {
            Thread.sleep(800);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        // 如果你要实现负载均衡，调用地址不能写具体主机地址
        // 需要将主机地址替换成对于服务的服务名，即 spring.application.name 指定的值
        // 你也可以到 Eureka server 中去查看
        String url = "http://SERVICE-DEMO/user/getAllUsers";
        // 使用 ParameterizedTypeReference 来保留泛型信息
        ParameterizedTypeReference<CommonReturn<List<User>>> typeRef = new ParameterizedTypeReference<CommonReturn<List<User>>>() {};
        ResponseEntity<CommonReturn<List<User>>> responseEntity = restTemplate.exchange(url, HttpMethod.GET, null, typeRef);
        return responseEntity.getBody();
    }

}
