package com.hxstrive.hystrix_demo.service;

import com.alibaba.fastjson.JSONObject;
import com.hxstrive.hystrix_demo.dto.CommonReturn;
import com.hxstrive.hystrix_demo.entity.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.List;

/**
 * 用户服务
 * @author hxstrive.com
 * @since 1.0.0  2024/11/13 15:20
 */
@Service
public class UserService {

    @Autowired
    private RestTemplate restTemplate;

    public CommonReturn<List<User>> getAllUsers() {
        // 如果你要实现负载均衡，调用地址不能写具体主机地址
        // 需要将主机地址替换成对于服务的服务名，即 spring.application.name 指定的值
        // 你也可以到 Eureka server 中去查看
        String url = "http://SERVICE-DEMO/user/getAllUsers";
        // 使用 ParameterizedTypeReference 来保留泛型信息
        ParameterizedTypeReference<CommonReturn<List<User>>> typeRef = new ParameterizedTypeReference<CommonReturn<List<User>>>() {};
        ResponseEntity<CommonReturn<List<User>>> responseEntity = restTemplate.exchange(url, HttpMethod.GET, null, typeRef);
        return responseEntity.getBody();
    }

    // 调用根据用户ID获取用户信息的接口
    public CommonReturn<User> getUserById(Long id) {
        String url = "http://SERVICE-DEMO/user/getUserById?id=" + id;
        // 使用 ParameterizedTypeReference 来保留泛型信息
        ParameterizedTypeReference<CommonReturn<User>> typeRef = new ParameterizedTypeReference<CommonReturn<User>>() {};
        ResponseEntity<CommonReturn<User>> responseEntity = restTemplate.exchange(url, HttpMethod.GET, null, typeRef);
        return responseEntity.getBody();
    }

    // 调用创建新用户的接口
    public CommonReturn<User> createUser(User user) {
        String url = "http://SERVICE-DEMO/user/createUser";
        HttpEntity<User> requestEntity = new HttpEntity<>(user);
        // 使用 ParameterizedTypeReference 来保留泛型信息
        ParameterizedTypeReference<CommonReturn<User>> typeRef = new ParameterizedTypeReference<CommonReturn<User>>() {};
        ResponseEntity<CommonReturn<User>> responseEntity = restTemplate.exchange(url, HttpMethod.POST, requestEntity, typeRef);
        return responseEntity.getBody();
    }

    // 调用更新用户信息的接口
    public CommonReturn<User> updateUser(Long id, User updatedUser) {
        String url = "http://SERVICE-DEMO/user/updateUser?id=" + id;
        HttpEntity<User> requestEntity = new HttpEntity<>(updatedUser);
        // 使用 ParameterizedTypeReference 来保留泛型信息
        ParameterizedTypeReference<CommonReturn<User>> typeRef = new ParameterizedTypeReference<CommonReturn<User>>() {};
        ResponseEntity<CommonReturn<User>> responseEntity = restTemplate.exchange(url, HttpMethod.PUT, requestEntity, typeRef);
        return responseEntity.getBody();
    }

    // 调用删除用户的接口
    public CommonReturn<String> deleteUser(Long id) {
        String url = "http://SERVICE-DEMO/user/deleteUser?id=" + id;
        // 使用 ParameterizedTypeReference 来保留泛型信息
        ParameterizedTypeReference<CommonReturn<String>> typeRef = new ParameterizedTypeReference<CommonReturn<String>>() {};
        ResponseEntity<CommonReturn<String>> responseEntity = restTemplate.exchange(url, HttpMethod.DELETE, null, typeRef);
        return responseEntity.getBody();
    }

}
