package com.hxstrive.service_demo;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 入口
 * @author Administrator
 */
@RestController
@SpringBootApplication
public class HystrixServiceUserApplication {

    @Value("${spring.application.name}")
    private String appName;

    @Value("${server.port}")
    private String appPort;


    public static void main(String[] args) {
        SpringApplication.run(HystrixServiceUserApplication.class, args);
    }


    @GetMapping("/")
    public String index() {
        return "appName=" + appName + ", appPort=" + appPort;
    }

}
