package com.hxstrive.service_demo.dto;

import lombok.Data;

/**
 * 通用返回对象
 * @author hxstrive.com
 */
@Data
public class CommonReturn<T> {
    private int code;
    private String message;
    private T data;
    private String appName;
    private String port;

    public static <T> CommonReturn<T> success(T data) {
        CommonReturn<T> commonReturn = new CommonReturn<>();
        commonReturn.setCode(1);
        commonReturn.setData(data);
        return commonReturn;
    }

    public static <T> CommonReturn<T> success() {
        return success(null);
    }

    public static <T> CommonReturn<T> fail(String message) {
        CommonReturn<T> commonReturn = new CommonReturn<>();
        commonReturn.setCode(0);
        commonReturn.setMessage(message);
        return commonReturn;
    }

    public CommonReturn<T> ext(String appName, String port) {
        this.setAppName(appName);
        this.setPort(port);
        return this;
    }

}
