package com.hxstrive.springcloud.loadbalancer_demo.demo1;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
@SpringBootApplication
@EnableDiscoveryClient
public class LoadbalancerDemoApplication {

    @Autowired
    private RestTemplate restTemplate;

    public static void main(String[] args) {
        SpringApplication.run(LoadbalancerDemoApplication.class, args);
    }

    @GetMapping("/getData")
    public String getData() throws Exception {
        // 关键：用服务名代替具体 IP:端口，LoadBalancer 会自动处理
        String url = "http://USER-SERVICE/api/users";  // 服务名与提供者的 spring.application.name 一致
        return restTemplate.getForObject(url, String.class);
    }

}
