package com.hxstrive.springcloud.loadbalancer_demo.demo2;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.web.client.RestTemplate;

@SpringBootApplication
@EnableDiscoveryClient
public class LoadbalancerDemoApplication implements CommandLineRunner {

    @Autowired
    private RestTemplate restTemplate;

    public static void main(String[] args) {
        SpringApplication.run(LoadbalancerDemoApplication.class, args);
    }

    @Override
    public void run(String... args) throws Exception {
        // 关键：用服务名代替具体 IP:端口，LoadBalancer 会自动处理
        String url = "http://USER-SERVICE/api/users";  // 服务名与提供者的 spring.application.name 一致
        String result = restTemplate.getForObject(url, String.class);

        System.out.println("####################################");
        System.out.println(result);
        System.out.println("####################################");
    }

}
