package com.hxstrive.springcloud.user.service.impl;

import com.hxstrive.springcloud.user.entity.User;
import com.hxstrive.springcloud.user.service.UserService;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class UserServiceImpl implements UserService {
    // 模拟数据库存储
    private List<User> userList;

    // 初始化20条模拟数据
    public UserServiceImpl() {
        userList = new ArrayList<>();
        userList.add(new User(1, "用户1", 21, "男", "user1@example.com", "工程师"));
        userList.add(new User(2, "用户2", 22, "女", "user2@example.com", "医生"));
        userList.add(new User(3, "用户3", 23, "男", "user3@example.com", "教师"));
        userList.add(new User(4, "用户4", 24, "女", "user4@example.com", "设计师"));
        userList.add(new User(5, "用户5", 25, "男", "user5@example.com", "程序员"));
        userList.add(new User(6, "用户6", 26, "女", "user6@example.com", "工程师"));
        userList.add(new User(7, "用户7", 27, "男", "user7@example.com", "医生"));
        userList.add(new User(8, "用户8", 28, "女", "user8@example.com", "教师"));
        userList.add(new User(9, "用户9", 29, "男", "user9@example.com", "设计师"));
        userList.add(new User(10, "用户10", 30, "女", "user10@example.com", "程序员"));
        userList.add(new User(11, "用户11", 31, "男", "user11@example.com", "工程师"));
        userList.add(new User(12, "用户12", 32, "女", "user12@example.com", "医生"));
        userList.add(new User(13, "用户13", 33, "男", "user13@example.com", "教师"));
        userList.add(new User(14, "用户14", 34, "女", "user14@example.com", "设计师"));
        userList.add(new User(15, "用户15", 35, "男", "user15@example.com", "程序员"));
        userList.add(new User(16, "用户16", 36, "女", "user16@example.com", "工程师"));
        userList.add(new User(17, "用户17", 37, "男", "user17@example.com", "医生"));
        userList.add(new User(18, "用户18", 38, "女", "user18@example.com", "教师"));
        userList.add(new User(19, "用户19", 39, "男", "user19@example.com", "设计师"));
        userList.add(new User(20, "用户20", 40, "女", "user20@example.com", "程序员"));
    }

    @Override
    public void save(User user) {
        // 生成新ID（取当前最大ID+1）
        int maxId = userList.stream()
                .mapToInt(User::getId)
                .max()
                .orElse(0);
        user.setId(maxId + 1);
        userList.add(user);
    }

    @Override
    public void update(User user) {
        User existingUser = findById(user.getId());
        if (existingUser != null) {
            existingUser.setName(user.getName());
            existingUser.setAge(user.getAge());
            existingUser.setGender(user.getGender());
            existingUser.setEmail(user.getEmail());
            existingUser.setProfession(user.getProfession());
        }
    }

    @Override
    public void delete(Integer id) {
        userList = userList.stream()
                .filter(user -> !user.getId().equals(id))
                .collect(Collectors.toList());
    }

    @Override
    public User findById(Integer id) {
        return userList.stream()
                .filter(user -> user.getId().equals(id))
                .findFirst()
                .orElse(null);
    }

    @Override
    public List<User> findAll() {
        return new ArrayList<>(userList); // 返回副本防止外部修改
    }
}